/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRPotions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovementInputFromOptions;

@SideOnly(value=Side.CLIENT)
public class LOTRDrunkenMovementHandler
extends MovementInputFromOptions {
    private final Minecraft gameInstance = Minecraft.func_71410_x();
    private final GameSettings controlSettings;
    private static final List<Integer> originalKeyBindings = Arrays.asList(2, 4, 3, 5);
    private final List<Integer> shuffledKeyBindings = new ArrayList<Integer>(originalKeyBindings);
    private boolean isKeysShuffled = false;

    public LOTRDrunkenMovementHandler(GameSettings settings) {
        super(settings);
        this.controlSettings = settings;
    }

    public void func_78898_a() {
        boolean shouldApplyEffect;
        EntityClientPlayerMP currentPlayer = this.gameInstance.field_71439_g;
        LOTRPlayerData playerData = LOTRLevelData.getData((EntityPlayer)currentPlayer);
        int alcoholTolerance = playerData.getAlcoholTolerance();
        boolean bl = shouldApplyEffect = alcoholTolerance <= 1000;
        if (!this.isKeysShuffled && currentPlayer.func_82165_m(LOTRPotions.drunk.field_76415_H) && shouldApplyEffect) {
            Collections.shuffle(this.shuffledKeyBindings);
            this.isKeysShuffled = true;
        }
        this.resetMovement();
        this.checkKeyBindings();
        this.handleJumpAndSneak(currentPlayer);
        if (currentPlayer.func_82165_m(LOTRPotions.drunk.field_76415_H) && !currentPlayer.field_71075_bZ.field_75101_c && shouldApplyEffect) {
            this.field_78901_c = false;
        }
    }

    private void resetMovement() {
        this.field_78902_a = 0.0f;
        this.field_78900_b = 0.0f;
    }

    private void checkKeyBindings() {
        if (this.controlSettings.field_74324_K[this.shuffledKeyBindings.get(0)].func_151470_d()) {
            this.field_78900_b += 1.0f;
        }
        if (this.controlSettings.field_74324_K[this.shuffledKeyBindings.get(1)].func_151470_d()) {
            this.field_78900_b -= 1.0f;
        }
        if (this.controlSettings.field_74324_K[this.shuffledKeyBindings.get(2)].func_151470_d()) {
            this.field_78902_a += 1.0f;
        }
        if (this.controlSettings.field_74324_K[this.shuffledKeyBindings.get(3)].func_151470_d()) {
            this.field_78902_a -= 1.0f;
        }
    }

    private void handleJumpAndSneak(EntityClientPlayerMP player) {
        this.field_78901_c = this.controlSettings.field_74314_A.func_151470_d();
        this.field_78899_d = this.controlSettings.field_74311_E.func_151470_d();
        if (this.field_78899_d) {
            this.field_78902_a = (float)((double)this.field_78902_a * 0.3);
            this.field_78900_b = (float)((double)this.field_78900_b * 0.3);
        }
    }

    public void resetShuffledKeys(EntityPlayerSP playerSP) {
        boolean shouldApplyEffect;
        LOTRPlayerData playerData = LOTRLevelData.getData((EntityPlayer)playerSP);
        boolean hasAchievement = playerData.hasAchievement(LOTRAchievement.gainHighAlcoholTolerance);
        int alcoholTolerance = playerData.getAlcoholTolerance();
        boolean bl = shouldApplyEffect = alcoholTolerance <= 1000;
        if (!(!this.isKeysShuffled || playerSP.func_82165_m(LOTRPotions.drunk.field_76415_H) && shouldApplyEffect)) {
            Collections.copy(this.shuffledKeyBindings, originalKeyBindings);
            this.isKeysShuffled = false;
        }
    }

    public void copyMovementData(MovementInput input) {
        this.field_78902_a = input.field_78902_a;
        this.field_78900_b = input.field_78900_b;
        this.field_78901_c = input.field_78901_c;
        this.field_78899_d = input.field_78899_d;
    }

    public static boolean shouldHandleDrunkenMovement(EntityPlayerSP playerSP) {
        LOTRPlayerData playerData = LOTRLevelData.getData((EntityPlayer)playerSP);
        int alcoholTolerance = playerData.getAlcoholTolerance();
        return playerSP.func_82165_m(LOTRPotions.drunk.field_76415_H) && alcoholTolerance <= 1000;
    }
}

